/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FTCanvas;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.FontSetter;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.QtoPixelPoint;

public class BoxInOtherWindowDialog
extends Dialog {
    private final String title_ = "Outline in other window";
    private final String targetString_ = "Target Window";
    private final String okString_ = "OK";
    private final String cancelString_ = "Cancel";
    private TextField targetText_;
    private Button okButton_;
    private int tempInt_ = 0;
    private FTWindow parentWindow_;
    private FTCentral fTCentral_;
    private BoxInOtherWindowDialog self_;

    public BoxInOtherWindowDialog(FTWindow fTWindow, FTCentral fTCentral) {
        super(fTWindow, "Outline window " + fTWindow.frameNumber() + " in other window", false);
        this.fTCentral_ = fTCentral;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.parentWindow_ = fTWindow;
        this.addWindowListener(new MyWindowActionListener());
        this.self_ = this;
        this.setLayout(new GridLayout(2, 1, 0, 5));
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        this.add(panel);
        this.add(panel2);
        panel.setLayout(new GridLayout(1, 2));
        Label label = new Label("Target Window");
        label.setAlignment(1);
        panel.add(label);
        arrayList.add(label);
        this.targetText_ = new TextField();
        panel.add(this.targetText_);
        this.targetText_.addTextListener(new WindowNumLNR());
        RunLNR runLNR2 = new RunLNR();
        this.targetText_.addActionListener(runLNR2);
        arrayList.add(this.targetText_);
        panel2.setLayout(new GridLayout(1, 2, 2, 0));
        Button button = new Button("Cancel");
        button.addActionListener(new CancelLNR());
        arrayList.add(button);
        panel2.add(button);
        this.okButton_ = new Button("OK");
        this.okButton_.addActionListener(runLNR2);
        panel2.add(this.okButton_);
        arrayList.add(this.okButton_);
        this.setSize(400, 90);
        String[] stringArray = new String[]{"Courier", "courier", "Dialog", "dialog", "Times", "times"};
        FontSetter fontSetter = new FontSetter(stringArray, 1, 12);
        fontSetter.setComponentFonts(arrayList);
        this.setVisible(true);
    }

    private boolean setTempInt(String string) {
        try {
            this.tempInt_ = Integer.valueOf(string);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    int getIntVaule(TextField textField) {
        String string = textField.getText();
        try {
            return Integer.valueOf(string);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private boolean goodWindowValueP(FTWindow fTWindow) {
        boolean bl;
        boolean bl2 = this.parentWindow_.getSpec().which.equals(fTWindow.getSpec().which);
        boolean bl3 = this.parentWindow_.getSpec().rangeOver == fTWindow.getSpec().rangeOver;
        boolean bl4 = bl = this.parentWindow_.getSpec().range < fTWindow.getSpec().range;
        if (!(bl2 && bl3 && bl)) {
            FTCentral.message("Invalid target window choice: " + (bl2 ? "" : "Different-Fractals ") + (bl ? "" : "Target window shows no more than than current window.") + (bl3 ? "" : "Windows vary diff Quaternians."), true);
        }
        return bl2 && bl3 && bl;
    }

    class MyWindowActionListener
    extends WindowAdapter {
        MyWindowActionListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            try {
                BoxInOtherWindowDialog.this.setVisible(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class WindowNumLNR
    implements TextListener {
        WindowNumLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            boolean bl;
            TextField textField = (TextField)textEvent.getSource();
            int n = BoxInOtherWindowDialog.this.getIntVaule(textField);
            FTWindow fTWindow = BoxInOtherWindowDialog.this.fTCentral_.getFrame(n);
            boolean bl2 = bl = fTWindow != null && BoxInOtherWindowDialog.this.goodWindowValueP(fTWindow);
            if (bl) {
                BoxInOtherWindowDialog.this.okButton_.setEnabled(true);
                textField.setForeground(Color.black);
            } else {
                BoxInOtherWindowDialog.this.okButton_.setEnabled(false);
                textField.setForeground(Color.red);
            }
        }
    }

    class RunLNR
    implements ActionListener {
        RunLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BoxInOtherWindowDialog.this.self_.setVisible(false);
                FractalSpec fractalSpec = BoxInOtherWindowDialog.this.parentWindow_.getSpec();
                QtoPixelPoint qtoPixelPoint = new QtoPixelPoint(fractalSpec);
                BigQuaternion bigQuaternion = qtoPixelPoint.getQuaternion(0, 0);
                BigQuaternion bigQuaternion2 = qtoPixelPoint.getQuaternion(fractalSpec.pix_width - 1, 0);
                BigQuaternion bigQuaternion3 = qtoPixelPoint.getQuaternion(fractalSpec.pix_width - 1, fractalSpec.pix_height - 1);
                BigQuaternion bigQuaternion4 = qtoPixelPoint.getQuaternion(0, fractalSpec.pix_height - 1);
                int n = BoxInOtherWindowDialog.this.getIntVaule(BoxInOtherWindowDialog.this.targetText_);
                FTWindow fTWindow = BoxInOtherWindowDialog.this.fTCentral_.getFrame(n);
                FractalSpec fractalSpec2 = fTWindow.getSpec();
                QtoPixelPoint qtoPixelPoint2 = new QtoPixelPoint(fractalSpec2);
                Point point = qtoPixelPoint2.getPixelPoint(bigQuaternion);
                Point point2 = qtoPixelPoint2.getPixelPoint(bigQuaternion2);
                Point point3 = qtoPixelPoint2.getPixelPoint(bigQuaternion3);
                Point point4 = qtoPixelPoint2.getPixelPoint(bigQuaternion4);
                Point point5 = new Point(point.x - 1, point.y - 1);
                Point point6 = new Point(point2.x + 1, point2.y - 1);
                Point point7 = new Point(point3.x + 1, point3.y + 1);
                Point point8 = new Point(point4.x - 1, point4.y + 1);
                fTWindow.toFront();
                FTCanvas fTCanvas = fTWindow.canvas();
                BoxInOtherWindowDialog.this.fTCentral_.setActiveCanvas(fTCanvas);
                fTCanvas.pushPolygonPoint(point);
                fTCanvas.pushPolygonPoint(point2);
                fTCanvas.pushPolygonPoint(point3);
                fTCanvas.pushPolygonPoint(point4);
                fTCanvas.pushPolygonPoint(point);
                fTCanvas.pushPolygonPoint(point5);
                fTCanvas.pushPolygonPoint(point6);
                fTCanvas.pushPolygonPoint(point7);
                fTCanvas.pushPolygonPoint(point8);
                fTCanvas.pushPolygonPoint(point5);
                fTCanvas.drawPolygonFlag();
                fTCanvas.repaint();
            }
            catch (Throwable throwable) {
                FTCentral cfr_ignored_0 = BoxInOtherWindowDialog.this.fTCentral_;
                FTCentral.message("Error in BoxInOtherWindowDialog$RunLNR: " + throwable.getMessage(), true);
            }
        }
    }

    class CancelLNR
    implements ActionListener {
        CancelLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BoxInOtherWindowDialog.this.setVisible(false);
        }
    }
}

