/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.Fraction;

public class BigQuaternion {
    public Fraction r;
    public Fraction i;
    public Fraction j;
    public Fraction k;

    public BigQuaternion(double d, double d2, double d3, double d4) {
        this.r = new Fraction(d);
        this.i = new Fraction(d2);
        this.j = new Fraction(d3);
        this.k = new Fraction(d4);
        this.setCommonDenominator();
    }

    public BigQuaternion(double d, double d2, double d3, double d4, int n) {
        this.r = new Fraction(d, n);
        this.i = new Fraction(d2, n);
        this.j = new Fraction(d3, n);
        this.k = new Fraction(d4, n);
        this.setCommonDenominator();
    }

    public BigQuaternion(Fraction fraction, Fraction fraction2, Fraction fraction3, Fraction fraction4) {
        this.r = fraction;
        this.i = fraction2;
        this.j = fraction3;
        this.k = fraction4;
        this.setCommonDenominator();
    }

    public BigQuaternion() {
        this.r = new Fraction(0.0);
        this.i = new Fraction(0.0);
        this.j = new Fraction(0.0);
        this.k = new Fraction(0.0);
    }

    public BigQuaternion(BigQuaternion bigQuaternion) {
        this.r = new Fraction(bigQuaternion.r);
        this.i = new Fraction(bigQuaternion.i);
        this.j = new Fraction(bigQuaternion.j);
        this.k = new Fraction(bigQuaternion.k);
    }

    public BigQuaternion(FastQuaternion fastQuaternion) {
        this.r = new Fraction(fastQuaternion.r);
        this.i = new Fraction(fastQuaternion.i);
        this.j = new Fraction(fastQuaternion.j);
        this.k = new Fraction(fastQuaternion.k);
    }

    private void setCommonDenominator() {
        Fraction.setCommonDenominator(this.r, this.i, this.j, this.k);
    }

    public int getLargestDenominator() {
        return Math.max(Math.max(this.r.getDenominator(), this.i.getDenominator()), Math.max(this.j.getDenominator(), this.k.getDenominator()));
    }

    public void setR(double d) {
        this.r = new Fraction(d);
    }

    public void setI(double d) {
        this.i = new Fraction(d);
    }

    public void setJ(double d) {
        this.j = new Fraction(d);
    }

    public void setK(double d) {
        this.k = new Fraction(d);
    }

    public void setR(Fraction fraction) {
        this.r = fraction;
    }

    public void setI(Fraction fraction) {
        this.i = fraction;
    }

    public void setJ(Fraction fraction) {
        this.j = fraction;
    }

    public void setK(Fraction fraction) {
        this.k = fraction;
    }

    public String rToString() {
        return this.r.toTokens();
    }

    public String iToString() {
        return this.i.toTokens();
    }

    public String jToString() {
        return this.j.toTokens();
    }

    public String kToString() {
        return this.k.toTokens();
    }

    public int scale() {
        return this.getDenominator();
    }

    public int getDenominator() {
        return this.r.getDenominator();
    }

    public BigQuaternion assign_from(BigQuaternion bigQuaternion) {
        this.r = new Fraction(bigQuaternion.r);
        this.i = new Fraction(bigQuaternion.i);
        this.j = new Fraction(bigQuaternion.j);
        this.k = new Fraction(bigQuaternion.k);
        return this;
    }

    public FastQuaternion fastQuaternionValue() {
        return new FastQuaternion(this.r.doubleValue(), this.i.doubleValue(), this.j.doubleValue(), this.k.doubleValue());
    }

    public boolean equal_p(BigQuaternion bigQuaternion) {
        return this.equals(bigQuaternion);
    }

    public boolean equals(BigQuaternion bigQuaternion) {
        return this.r.equals(bigQuaternion.r) && this.i.equals(bigQuaternion.i) && this.j.equals(bigQuaternion.j) && this.k.equals(bigQuaternion.k);
    }

    public static void setCommonDenominator(BigQuaternion ... bigQuaternionArray) {
        if (bigQuaternionArray.length > 0) {
            Fraction[] fractionArray = new Fraction[bigQuaternionArray.length * 4];
            int n = 0;
            for (BigQuaternion bigQuaternion : bigQuaternionArray) {
                fractionArray[n++] = bigQuaternion.r;
                fractionArray[n++] = bigQuaternion.i;
                fractionArray[n++] = bigQuaternion.j;
                fractionArray[n++] = bigQuaternion.k;
            }
            Fraction.setCommonDenominator(fractionArray);
        }
    }

    public BigQuaternion plus(BigQuaternion bigQuaternion) {
        return new BigQuaternion(this.r.add(bigQuaternion.r), this.i.add(bigQuaternion.i), this.j.add(bigQuaternion.j), this.k.add(bigQuaternion.k));
    }

    public BigQuaternion plus_equal(BigQuaternion bigQuaternion) {
        this.r.plus_equal(bigQuaternion.r);
        this.i.plus_equal(bigQuaternion.i);
        this.j.plus_equal(bigQuaternion.j);
        this.k.plus_equal(bigQuaternion.k);
        return this;
    }

    public BigQuaternion plus_equal(FastQuaternion fastQuaternion) throws Exception {
        return this.plus_equal(new BigQuaternion(fastQuaternion.r, fastQuaternion.i, fastQuaternion.j, fastQuaternion.k));
    }

    public BigQuaternion minus(BigQuaternion bigQuaternion) {
        return new BigQuaternion(this.r.subtract(bigQuaternion.r), this.i.subtract(bigQuaternion.i), this.j.subtract(bigQuaternion.j), this.k.subtract(bigQuaternion.k));
    }

    public BigQuaternion minus_equal(BigQuaternion bigQuaternion) {
        this.r.minus_equal(bigQuaternion.r);
        this.i.minus_equal(bigQuaternion.i);
        this.j.minus_equal(bigQuaternion.j);
        this.k.minus_equal(bigQuaternion.k);
        return this;
    }

    public BigQuaternion times(BigQuaternion bigQuaternion) {
        return new BigQuaternion(this.r.multiply(bigQuaternion.r).subtract(this.i.multiply(bigQuaternion.i)).subtract(this.j.multiply(bigQuaternion.j)).subtract(this.k.multiply(bigQuaternion.k)), this.r.multiply(bigQuaternion.i).add(this.i.multiply(bigQuaternion.r)).add(this.j.multiply(bigQuaternion.k)).subtract(this.k.multiply(bigQuaternion.j)), this.r.multiply(bigQuaternion.j).subtract(this.i.multiply(bigQuaternion.k)).add(this.j.multiply(bigQuaternion.r)).add(this.k.multiply(bigQuaternion.i)), this.r.multiply(bigQuaternion.k).add(this.i.multiply(bigQuaternion.j)).subtract(this.j.multiply(bigQuaternion.i)).add(this.k.multiply(bigQuaternion.r)));
    }

    public BigQuaternion times_equal(BigQuaternion bigQuaternion) throws Exception {
        Fraction fraction = this.r.multiply(bigQuaternion.r).minus_equal(this.i.multiply(bigQuaternion.i)).minus_equal(this.j.multiply(bigQuaternion.j)).minus_equal(this.k.multiply(bigQuaternion.k));
        Fraction fraction2 = this.r.multiply(bigQuaternion.i).plus_equal(this.i.multiply(bigQuaternion.r)).plus_equal(this.j.multiply(bigQuaternion.k)).minus_equal(this.k.multiply(bigQuaternion.j));
        Fraction fraction3 = this.r.multiply(bigQuaternion.j).minus_equal(this.i.multiply(bigQuaternion.k)).plus_equal(this.j.multiply(bigQuaternion.r)).plus_equal(this.k.multiply(bigQuaternion.i));
        Fraction fraction4 = this.r.multiply(bigQuaternion.k).plus_equal(this.i.multiply(bigQuaternion.j)).minus_equal(this.j.multiply(bigQuaternion.i)).plus_equal(this.k.multiply(bigQuaternion.r));
        this.r = fraction;
        this.i = fraction2;
        this.j = fraction3;
        this.k = fraction4;
        return this;
    }

    public BigQuaternion times_scalar(int n) {
        return new BigQuaternion(this.r.timesScalar(n), this.i.timesScalar(n), this.j.timesScalar(n), this.k.timesScalar(n));
    }

    public BigQuaternion times_scalar(double d) {
        return new BigQuaternion(this.r.timesScalar(d), this.i.timesScalar(d), this.j.timesScalar(d), this.k.timesScalar(d));
    }

    public BigQuaternion times_scalar(Fraction fraction) {
        Fraction.setCommonDenominator(fraction, this.r, this.i, this.j, this.k);
        return new BigQuaternion(this.r.multiply(fraction), this.i.multiply(fraction), this.j.multiply(fraction), this.k.multiply(fraction));
    }

    public Fraction dot(BigQuaternion bigQuaternion) {
        return this.r.multiply(bigQuaternion.r).add(this.i.multiply(bigQuaternion.i)).add(this.j.multiply(bigQuaternion.j)).add(this.k.multiply(bigQuaternion.k));
    }

    public Fraction magnitude() {
        Fraction fraction = new Fraction(this.r);
        fraction.setDenominatorValue(this.r.getDenominator() * 2);
        Fraction fraction2 = new Fraction(this.i);
        fraction2.setDenominatorValue(this.i.getDenominator() * 2);
        Fraction fraction3 = new Fraction(this.j);
        fraction3.setDenominatorValue(this.j.getDenominator() * 2);
        Fraction fraction4 = new Fraction(this.k);
        fraction4.setDenominatorValue(this.k.getDenominator() * 2);
        BigQuaternion bigQuaternion = new BigQuaternion(fraction, fraction2, fraction3, fraction4);
        Fraction fraction5 = bigQuaternion.dot(bigQuaternion).sqrt();
        fraction5.setDenominatorValue(fraction5.getDenominator() / 2);
        return fraction5;
    }

    public Fraction magnitude_sq() {
        return this.dot(this);
    }

    public BigQuaternion adjustPrecision(int n) {
        Fraction fraction = new Fraction(this.r);
        fraction.setDenominatorValue(this.r.getDenominator() + n);
        Fraction fraction2 = new Fraction(this.i);
        fraction2.setDenominatorValue(this.i.getDenominator() + n);
        Fraction fraction3 = new Fraction(this.j);
        fraction3.setDenominatorValue(this.j.getDenominator() + n);
        Fraction fraction4 = new Fraction(this.k);
        fraction4.setDenominatorValue(this.k.getDenominator() + n);
        BigQuaternion bigQuaternion = new BigQuaternion(fraction, fraction2, fraction3, fraction4);
        return bigQuaternion;
    }

    public void print(String string) {
        System.out.println(string + " r=" + this.r.toString() + " i=" + this.i.toString() + " j=" + this.j.toString() + " k=" + this.k.toString());
    }

    public String toString() {
        return "<BigQuaternion r=" + this.r.toString() + " i=" + this.i.toString() + " j=" + this.j.toString() + " k=" + this.k.toString() + ">";
    }
}

