/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import us.lystad.fractaltop.Fraction;

class BigLabeledTextField
extends Panel
implements KeyListener,
TextListener {
    Fraction fraction_value = new Fraction(0.0);
    private TextField text_ = null;
    private Vector<ActionListener> myActionListeners;

    public BigLabeledTextField() {
        this.setLayout(new BorderLayout(2, 2));
        this.text_ = new TextField("0", 24);
        this.text_.addKeyListener(this);
        this.text_.addTextListener(this);
        this.add("Center", this.text_);
        this.myActionListeners = new Vector(1);
        this.valueOk_p();
    }

    public void setValue(double d) {
        String string = String.valueOf(d);
        this.text_.setText(string);
        this.fraction_value.setValue(new Fraction(d));
    }

    public void setValue(Fraction fraction) {
        String string = fraction.toString();
        this.text_.setText(string);
        this.fraction_value.setValue(fraction);
    }

    public String getText() {
        return this.text_.getText();
    }

    @Override
    public void setFont(Font font) {
        this.text_.setFont(font);
        super.setFont(font);
    }

    private boolean doubleConvertible_p(String string) {
        try {
            this.fraction_value = new Fraction(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean valueOk_p(String string) {
        try {
            Fraction fraction = new Fraction(string);
            this.text_.setForeground(Color.black);
            this.repaint();
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.text_.setForeground(Color.red);
            this.repaint();
            return false;
        }
    }

    public boolean valueOk_p() {
        return this.valueOk_p(this.text_.getText());
    }

    public Fraction fractionValue() {
        return this.fraction_value;
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        String string = this.text_.getText();
        if (string.length() > 0) {
            try {
                this.fraction_value = new Fraction(string);
                this.text_.setForeground(Color.black);
            }
            catch (NumberFormatException numberFormatException) {
                this.text_.setForeground(Color.red);
            }
            this.repaint();
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        this.text_.addKeyListener(keyListener);
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.text_.addTextListener(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.text_.removeTextListener(textListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.myActionListeners.addElement(actionListener);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Enumeration<ActionListener> enumeration;
        if (keyEvent.getKeyChar() != '\n') {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            enumeration = this.myActionListeners.elements();
        }
        serializable = new ActionEvent(this, 1001, "Return Typed");
        try {
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().actionPerformed((ActionEvent)serializable);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println("The impossible has happened in Labeled_Text_Field.keyTyped.  " + noSuchElementException);
        }
    }
}

